/*
    This simple extension of the java.awt.Frame class
    contains all the elements necessary to act as the
    main window of an application.
 */

import java.awt.*;

public class Frame1 extends Frame {


	void About_Action(Event event) {
		//{{CONNECTION
		// Action from About Create and show as modal
		(new AboutDialog(this, true)).show();
		//}}
	}

	void Exit_Action(Event event) {
		//{{CONNECTION
		// Action from Exit Create and show as modal
		(new QuitDialog(this, true)).show();
		//}}
	}

	public Frame1() {

		//{{INIT_CONTROLS
		setLayout(null);
		addNotify();
		resize(insets().left + insets().right + 443,insets().top + insets().bottom + 226);
		setBackground(new Color(12632256));
		tabbingPanel1 = new TabbingPanel();
		tabbingPanel1.setLayout(null);
		tabbingPanel1.reshape(insets().left + 12,insets().top + 12,420,204);
		tabbingPanel1.setBackground(new Color(12632256));
		add(tabbingPanel1);
		textField1 = new java.awt.TextField();
		textField1.setText("Hello");
		textField1.reshape(12,24,120,28);
		tabbingPanel1.add(textField1);
		textField3 = new java.awt.TextField();
		textField3.setEditable(false);
		textField3.setText("There");
		textField3.reshape(144,24,120,28);
		tabbingPanel1.add(textField3);
		textField4 = new java.awt.TextField();
		textField4.setText("Bye");
		textField4.reshape(288,24,120,28);
		tabbingPanel1.add(textField4);
		button1 = new java.awt.Button("Cool");
		button1.reshape(12,96,96,24);
		tabbingPanel1.add(button1);
		button2 = new java.awt.Button("Disabled");
		button2.disable();
		button2.reshape(156,96,96,24);
		tabbingPanel1.add(button2);
		button3 = new java.awt.Button("Hot");
		button3.reshape(288,96,96,24);
		tabbingPanel1.add(button3);
		choice1 = new java.awt.Choice();
		choice1.addItem("Neat");
		choice1.addItem("Messy");
		tabbingPanel1.add(choice1);
		choice1.reshape(156,144,100,21);
		setTitle("A Basic Application");
		//}}

		//{{INIT_MENUS
		mainMenuBar = new java.awt.MenuBar();

		menu1 = new java.awt.Menu("File");
		menu1.add("Exit");
		mainMenuBar.add(menu1);

		menu2 = new java.awt.Menu("Edit");
		menuItem3 = new java.awt.MenuItem("Cut");
		menuItem3.disable();
		menu2.add(menuItem3);
		menuItem2 = new java.awt.MenuItem("Copy");
		menuItem2.disable();
		menu2.add(menuItem2);
		menuItem1 = new java.awt.MenuItem("Paste");
		menuItem1.disable();
		menu2.add(menuItem1);
		mainMenuBar.add(menu2);

		menu3 = new java.awt.Menu("Help");
		mainMenuBar.setHelpMenu(menu3);
		menu3.add("About");
		mainMenuBar.add(menu3);
		setMenuBar(mainMenuBar);
		//$$ mainMenuBar.move(0,0);
		//}}
		UserInits();
	}

    private void UserInits(){
        tabbingPanel1.InitializePanel();
        textField1.requestFocus();
    }
    
	public Frame1(String title) {
	    this();
	    setTitle(title);
	}

    public synchronized void show() {
    	move(50, 50);
    	super.show();
    }

	public boolean handleEvent(Event event) {
    	if (event.id == Event.WINDOW_DESTROY) {
            hide();         // hide the Frame
            dispose();      // free the system resources
            System.exit(0); // close the application
            return true;
    	}
		return super.handleEvent(event);
	}

	public boolean action(Event event, Object arg) {
		if (event.target instanceof MenuItem) {
			String label = (String) arg;
			if (label.equalsIgnoreCase("About")) {
				About_Action(event);
				return true;
			} else
				if (label.equalsIgnoreCase("Exit")) {
					Exit_Action(event);
					return true;
			}
		}
		return super.action(event, arg);
	}

	static public void main(String args[]) {
	    (new Frame1()).show();
	}

	//{{DECLARE_CONTROLS
	TabbingPanel tabbingPanel1;
	java.awt.TextField textField1;
	java.awt.TextField textField3;
	java.awt.TextField textField4;
	java.awt.Button button1;
	java.awt.Button button2;
	java.awt.Button button3;
	java.awt.Choice choice1;
	//}}

	//{{DECLARE_MENUS
	java.awt.MenuBar mainMenuBar;
	java.awt.Menu menu1;
	java.awt.Menu menu2;
	java.awt.MenuItem menuItem3;
	java.awt.MenuItem menuItem2;
	java.awt.MenuItem menuItem1;
	java.awt.Menu menu3;
	//}}
}
